/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.sequence.builder;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.util.sequence.builder.ISequenceBuilder;

public final class StringSequenceBuilder
implements ISequenceBuilder<StringSequenceBuilder, CharSequence> {
    private final StringBuilder segments;

    @NotNull
    public static StringSequenceBuilder emptyBuilder() {
        return new StringSequenceBuilder();
    }

    private StringSequenceBuilder() {
        this.segments = new StringBuilder();
    }

    public StringSequenceBuilder(int initialCapacity) {
        this.segments = new StringBuilder(initialCapacity);
    }

    @Override
    @NotNull
    public StringSequenceBuilder getBuilder() {
        return new StringSequenceBuilder();
    }

    @Override
    public char charAt(int index) {
        return this.segments.charAt(index);
    }

    @Override
    @NotNull
    public StringSequenceBuilder append(@Nullable CharSequence chars, int startIndex, int endIndex) {
        if (chars != null && chars.length() > 0 && startIndex < endIndex) {
            this.segments.append(chars, startIndex, endIndex);
        }
        return this;
    }

    @Override
    @NotNull
    public StringSequenceBuilder append(char c) {
        this.segments.append(c);
        return this;
    }

    @Override
    @NotNull
    public StringSequenceBuilder append(char c, int count) {
        while (count-- > 0) {
            this.segments.append(c);
        }
        return this;
    }

    @Override
    @NotNull
    public CharSequence getSingleBasedSequence() {
        return this.toSequence();
    }

    @Override
    @NotNull
    public CharSequence toSequence() {
        return this.segments;
    }

    @Override
    public int length() {
        return this.segments.length();
    }

    public String toString() {
        return this.segments.toString();
    }
}

